#!/usr/bin/env perl

BEGIN { use lib 't'; require 'testlib.pl'; }

use Modern::Perl;

# BUG_0016: RCM2000 and RCM3000 emulation routines not assembled when LIST is ON (-l)
for my $list ("", "-l") {
	z80asm_ok("-b $list",        "", "", "cpi", bytes(0xed, 0xa1));
	z80asm_ok("-b $list -mr2ka", "", "", "cpi", 
	          bytes(0xCD, 0x03, 0x00,
					0x38, 0x14, 0xBE, 0x23, 0x0B, 0xF5, 0xED, 0x54, 0xCB, 0x85, 
					0xCB, 0xD5, 0x78, 0xB1, 0x20, 0x02, 0xCB, 0x95, 0xED, 0x54, 
					0xF1, 0xC9, 0xBE, 0x23, 0x0B, 0xF5, 0xED, 0x54, 0xCB, 0xC5,
					0x18, 0xEA));
}

unlink_testfiles;
done_testing;
